% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{construct_weights}
\alias{construct_weights}
\title{Construct internal and external weights}
\usage{
construct_weights(coef, id)
}
\arguments{
\item{coef}{matrix with \eqn{p} rows (features) and \eqn{q} columns (problems)}

\item{id}{integer in \eqn{1,\ldots,q}}
}
\value{
Returns a list with slots
\code{lower.limits}, \code{upper.limits},
\code{weight.source} (external weights)
and \code{weight.target} (internal weights).
Each slot is a vector of length \eqn{2*p},
with the first \eqn{p} entries for positive effects
and the last \eqn{p} entries for negative effects.
}
\description{
Construct internal and external weights
}
\examples{
p <- 10
q <- 3
data <- stats::rbinom(p*q,size=1,prob=0.2)*stats::rnorm(p*q)
coef <- matrix(data=data,nrow=p,ncol=q)
construct_weights(coef=coef,id=1)

}
\seealso{
Use \code{\link{construct_penfacs}} to obtain penalty factors
(i.e., for scaling and inverting weights).
}
\keyword{internal}
