% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_binary.R
\name{is_binary}
\alias{is_binary}
\title{Check if variable is binary with values 0 and 1}
\usage{
is_binary(data = NULL, dependent.variable.name = NULL)
}
\arguments{
\item{data}{Data frame containing the variable to check.}

\item{dependent.variable.name}{Character string with the name of the variable to test. Must be a column name in \code{data}.}
}
\value{
Logical. \code{TRUE} if the variable contains exactly two unique values (0 and 1), \code{FALSE} otherwise.
}
\description{
Tests whether a variable contains only the values 0 and 1.
}
\details{
This function is used internally by spatialRF to determine whether to apply classification-specific methods (e.g., case weighting with \code{\link[=case_weights]{case_weights()}}). The function returns \code{FALSE} if:
\itemize{
\item The variable has more than two unique values
\item The variable has only one unique value (constant)
\item The unique values are not exactly 0 and 1 (e.g., 1 and 2, or TRUE and FALSE)
}

Missing values (NA) are ignored when determining unique values.
}
\examples{
# Binary variable (returns TRUE)
is_binary(
  data = data.frame(response = c(0, 0, 0, 1, 1)),
  dependent.variable.name = "response"
)

# Non-binary variable (returns FALSE)
is_binary(
  data = data.frame(response = c(1, 2, 3, 4, 5)),
  dependent.variable.name = "response"
)

# Binary but wrong values (returns FALSE)
is_binary(
  data = data.frame(response = c(1, 1, 2, 2)),
  dependent.variable.name = "response"
)

}
\seealso{
\code{\link[=case_weights]{case_weights()}}

Other preprocessing: 
\code{\link{auto_cor}()},
\code{\link{auto_vif}()},
\code{\link{case_weights}()},
\code{\link{default_distance_thresholds}()},
\code{\link{double_center_distance_matrix}()},
\code{\link{make_spatial_fold}()},
\code{\link{make_spatial_folds}()},
\code{\link{the_feature_engineer}()},
\code{\link{weights_from_distance_matrix}()}
}
\concept{preprocessing}
