% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_optimization.R
\name{plot_optimization}
\alias{plot_optimization}
\title{Optimization plot of a selection of spatial predictors}
\usage{
plot_optimization(
  model,
  point.color = viridis::viridis(
    100,
    option = "F",
    direction = -1
  ),
  verbose = TRUE
)
}
\arguments{
\item{model}{A model produced by \code{\link[=rf_spatial]{rf_spatial()}}, or an optimization data frame produced by \code{\link[=select_spatial_predictors_sequential]{select_spatial_predictors_sequential()}} or \code{\link[=select_spatial_predictors_recursive]{select_spatial_predictors_recursive()}}.}

\item{point.color}{Colors of the plotted points. Can be a single color name (e.g. "red4"), a character vector with hexadecimal codes (e.g. "#440154FF" "#21908CFF" "#FDE725FF"), or function generating a palette (e.g. \code{viridis::viridis(100)}). Default: \code{viridis::viridis(100, option = "F", direction = -1)}}

\item{verbose}{Logical, if \code{TRUE} the plot is printed. Default: \code{TRUE}}
}
\value{
A ggplot, or \code{NULL} invisibly if no optimization data is available.
}
\description{
Plots optimization data frames produced by \code{\link[=select_spatial_predictors_sequential]{select_spatial_predictors_sequential()}}
and \code{\link[=select_spatial_predictors_recursive]{select_spatial_predictors_recursive()}}.
}
\details{
The function returns \code{NULL} invisibly (without plotting) when:
\itemize{
\item The method used to fit a model with \code{\link[=rf_spatial]{rf_spatial()}} is "hengl" (no optimization required)
\item No spatial predictors were selected during model fitting
\item The model is non-spatial
}
}
\examples{

data(plants_rf_spatial)

plot_optimization(plants_rf_spatial)

}
\seealso{
Other visualization: 
\code{\link{plot_evaluation}()},
\code{\link{plot_importance}()},
\code{\link{plot_moran}()},
\code{\link{plot_residuals_diagnostics}()},
\code{\link{plot_response_curves}()},
\code{\link{plot_response_surface}()},
\code{\link{plot_training_df}()},
\code{\link{plot_training_df_moran}()},
\code{\link{plot_tuning}()}
}
\concept{visualization}
