% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spatial_metrics.R
\name{composition_index}
\alias{composition_index}
\title{Composition imbalance index}
\usage{
composition_index(x)
}
\arguments{
\item{x}{SpatRaster or matrix containing two values: -1 and 1}
}
\value{
A numeric vector
}
\description{
Calculates composition imbalance index (also known as the m index) -- a sum of cell’s values
over the entire site divided by the number of cell in the site.
m has a range from -1 (site completely dominated by the -1 values) to
1 (site completely dominated by the 1 values).
}
\examples{
data(r_start, package = "spatialising")
composition_index(r_start)
ts1 = kinetic_ising(r_start, B = -0.3, J = 0.7)
composition_index(ts1)
ts2 = kinetic_ising(r_start, B = -0.3, J = 0.7, updates = 2)
composition_index(ts2)

\donttest{
  library(terra)
  r1 = rast(system.file("raster/r_start.tif", package = "spatialising"))
  composition_index(r1)
  r2 = kinetic_ising(r1, B = -0.3, J = 0.7)
  composition_index(r2)
}
}
\seealso{
\code{\link[=kinetic_ising]{kinetic_ising()}}
}
