% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spef_data.R
\docType{data}
\name{blaTum}
\alias{blaTum}
\title{Bladder Tumors Cancer Recurrences}
\format{A \code{data.frame} contains the following columns:
\describe{
  \item{\code{id}}{patient id}
  \item{\code{treatment}}{placebo = 0, thiotepa = 1}
  \item{\code{size}}{size (cm) of largest initial tumor}
  \item{\code{num}}{initial number of tumors (8 = 8 or more)}
  \item{\code{time}}{observation time}
  \item{\code{count}}{number of new tumors since last observation time}
}}
\usage{
data(blaTum)
}
\description{
A data frame contains data on recurrences of bladder cancer,
used by many people to demonstrate methodology for recurrent event modelling.
This data set organized differently from \code{bladTumor}.
The data contains records of 85 patients from two treatment arms:
48 are from the placebo arm, and the rest 37 are from the thiotepa arm.
}
\note{
To our surprise, the two-treatment (placebo and thiotepa) subset of
the full version \code{bladTumor} do not match the two-treatment version \code{blaTum}.
}
\examples{
data(blaTum)
library(ggplot2)
ggplot(blaTum, aes(time, id)) + geom_tile(aes(fill=count)) +
    facet_grid(treatment ~ ., scales="free_y", )
}
\references{
Byar, D. P. (1980). The Veterans administration study of chemoprophylaxis for
recurrent stage I bladder tumors: comparisons of placebo, pyridoxine, and topical thiotepa.
\emph{Bladder Tumors and Other Topics in Urological Oncology}, pp. 363--370. New York: Plenum.

Sun, J. and Wei, L. J. (2000) Regression analysis of panel count data
 with covariate dependent observation and censoring times.
 \emph{Journal of the Royal Statistical Society, Series B: Statistical Methodology},
\bold{62}(2), 293--302.

Huang, C. Y., Wang, M. C. and Zhang, Y. (2006).
Analyzing panel count data with informative observation times.
\emph{Biometrika}, \bold{93}(4): 763--776.
}
\seealso{
\code{\link{bladTumor}}
}
