% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.initials.R
\name{get.initials}
\alias{get.initials}
\title{Get initial values for spexvb}
\usage{
get.initials(
  X,
  Y,
  mu_0 = NULL,
  omega_0 = NULL,
  c_pi_0 = NULL,
  d_pi_0 = NULL,
  tau_e = NULL,
  update_order = NULL,
  seed = 12376
)
}
\arguments{
\item{X}{A design matrix.}

\item{Y}{A response vector.}

\item{mu_0}{Initial mean.}

\item{omega_0}{Initial omega.}

\item{c_pi_0}{Initial c_pi.}

\item{d_pi_0}{Initial d_pi.}

\item{tau_e}{Initial tau_e.}

\item{update_order}{Initial update order.}

\item{seed}{Seed for reproducibility.}
}
\value{
A list of initialized parameters.
}
\description{
This function initializes parameters for the spexvb model.
}
\details{
Generate Initial Values for Variational Inference in Sparse Regression

This helper function estimates initial values for variational parameters such as
regression coefficients (\code{mu}), spike probabilities (\code{omega}), and hyperparameters
like \code{tau_e}, \code{c_pi}, and \code{d_pi} using LASSO and Ridge regression fits.
}
\examples{
\donttest{
n <- 50
p <- 100
X <- matrix(rnorm(n * p), n, p)
Y <- X[,1] * 2 + rnorm(n)

initials <- get.initials(X, Y)

# Check estimated noise precision (tau_e)
print(initials$tau_e)
}
}
