% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vif.ev.R
\name{vif.ev}
\alias{vif.ev}
\title{Variance Inflation Factor of Eigenvectors}
\usage{
vif.ev(x = NULL, evecs, na.rm = TRUE)
}
\arguments{
\item{x}{vector/ matrix of regressors (default = NULL)}

\item{evecs}{(selected) eigenvectors}

\item{na.rm}{remove missing values in covariates (TRUE/ FALSE)}
}
\value{
Returns a vector containing the VIF for each eigenvector.
}
\description{
Calculate the variance inflation factor (VIF) of
the eigenvectors in the spatial filter.
}
\note{
This function assumes a linear model which ensures the
uncorrelatedness of the eigenvectors. Note that regression weights
or the link function used in generalized linear models can corrupt
this property.
}
\examples{
data(fakedata)
E <- getEVs(W = W, covars = NULL)$vectors
(VIF <- vif.ev(x = fakedataset$x1, evecs = E[, 1:10]))

}
\seealso{
\code{\link{lmFilter}}, \code{\link{getEVs}}
}
\author{
Sebastian Juhl
}
