% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linear-spherical-spline.R
\name{cartesian_to_spherical}
\alias{cartesian_to_spherical}
\title{Convert Cartesian coordinates to spherical coordinates}
\usage{
cartesian_to_spherical(x, byrow = TRUE)
}
\arguments{
\item{x}{A matrix where each row represents a point in Cartesian coordinates.}

\item{byrow}{logical. If TRUE (the default) the matrix is filled by rows, otherwise the matrix is filled by columns.}
}
\value{
A matrix where each row represents a point in spherical coordinates.
}
\description{
This function converts Cartesian coordinates to spherical coordinates.
}
\details{
The Cartesian coordinates (x, y, z) are converted to spherical coordinates (theta, phi).
Theta represents the inclination angle (0 to pi), and phi represents the azimuth angle (0 to 2*pi).
}
\examples{
#example1
cartesian_points1 <- matrix(c(1/sqrt(3), 1/sqrt(3), 1/sqrt(3),-1/sqrt(3), 1/sqrt(3), -1/sqrt(3)),
  ncol = 3, byrow = TRUE)
cartesian_to_spherical(cartesian_points1)
#example2
cartesian_points2 <- matrix(c(1, 0, 0, 0, 1, 0, 0, 0, 1),ncol = 3, byrow = TRUE)
cartesian_to_spherical(cartesian_points2)
}
