% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sphunif-package.R
\docType{package}
\name{sphunif-package}
\alias{sphunif-package}
\alias{sphunif}
\title{\code{sphunif}: Uniformity Tests on the Circle, Sphere, and
Hypersphere}
\description{
Implementation of uniformity tests on the circle and
(hyper)sphere. The main function of the package is \code{\link{unif_test}},
which conveniently collects more than 35 tests for assessing uniformity on
\eqn{S^{p-1}=\{{\bf x}\in R^p:||{\bf x}||=1\}}{
S^{p-1}=\{x\in R^p:||x||=1\}}, \eqn{p\ge 2}. The test statistics are
implemented in the \code{\link{unif_stat}} function, which allows computing
several statistics for different samples within a single call, thus
facilitating Monte Carlo experiments. Furthermore, the
\code{\link{unif_stat_MC}} function allows parallelizing them in
a simple way. The asymptotic null distributions of the statistics are
available through the function \code{\link{unif_stat_distr}}. The core of
\code{\link{sphunif-package}} is coded in C++ by relying on the
\code{\link[Rcpp]{Rcpp-package}}. The package also provides several
novel datasets and gives the replicability for the data applications/
simulations in García-Portugués et al. (2021)
<doi:10.1007/978-3-030-69944-4_12>, García-Portugués et al. (2023)
<doi:10.3150/21-BEJ1454>, Fernández-de-Marcos and García-Portugués (2024)
<doi:10.1016/j.spl.2024.110218> and García-Portugués et al. (2025)
<doi:10.1080/01621459.2025.2566414>.
}
\references{
Fernández-de-Marcos, A. and García-Portugués, E. (2024) A stereographic test
of spherical uniformity. \emph{Statistics & Probability Letters},
215:110218. \doi{doi:10.1016/j.spl.2024.110218}

García-Portugués, E. and Verdebout, T. (2018) An overview of uniformity
tests on the hypersphere. \emph{arXiv:1804.00286}.
\doi{10.48550/arXiv.1804.00286}

García-Portugués, E., Navarro-Esteban, P., Cuesta-Albertos, J. A. (2023)
On a projection-based class of uniformity tests on the hypersphere.
\emph{Bernoulli}, 29(1):181--204. \doi{10.3150/21-BEJ1454}

García-Portugués, E., Navarro-Esteban, P., and Cuesta-Albertos, J. A. (2021).
A Cramér–von Mises test of uniformity on the hypersphere. In Balzano, S.,
Porzio, G. C., Salvatore, R., Vistocco, D., and Vichi, M. (Eds.), \emph{
Statistical Learning and Modeling in Data Analysis}, Studies in
Classification, Data Analysis and Knowledge Organization, pp. 107--116.
Springer, Cham. \doi{10.1007/978-3-030-69944-4_12}

García-Portugués, E., Paindaveine, D., and Verdebout, T. (2025). On a class
of Sobolev tests for symmetry, their detection thresholds, and asymptotic
powers. \emph{Journal of the American Statistical Association}.
\doi{10.1080/01621459.2025.2566414}
}
\seealso{
Useful links:
\itemize{
  \item \url{https://github.com/egarpor/sphunif}
  \item Report bugs at \url{https://github.com/egarpor/sphunif/issues}
}

}
\author{
Eduardo García-Portugués and Thomas Verdebout.
}
