% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tables_ascii.R
\name{build_ascii_table}
\alias{build_ascii_table}
\title{Build a formatted ASCII table (internal spicy engine)}
\usage{
build_ascii_table(
  x,
  padding = c("compact", "normal", "wide"),
  first_column_line = TRUE,
  row_total_line = TRUE,
  column_total_line = TRUE,
  bottom_line = FALSE,
  lines_color = "darkgrey",
  align_left_cols = c(1L, 2L),
  ...
)
}
\arguments{
\item{x}{A \code{data.frame} or \code{spicy_table} object containing the table to format.
Typically, this includes columns such as \emph{Category}, \emph{Values}, \emph{Freq.}, \emph{Percent}, etc.}

\item{padding}{Character string controlling horizontal spacing between columns:
\itemize{
\item \code{"compact"} — minimal spacing
\item \code{"normal"} — moderate spacing (default)
\item \code{"wide"} — extra spacing (for large displays or wide content)
}}

\item{first_column_line}{Logical. If \code{TRUE} (default), a vertical separator
is drawn after the first column (useful for separating categories from data).}

\item{row_total_line, column_total_line}{Logical. Control horizontal rules
before total rows or columns (default: \code{TRUE}).}

\item{bottom_line}{Logical. If \code{TRUE}, draws a closing line at the
bottom of the table (default: \code{FALSE}).}

\item{lines_color}{Character. Color used for table separators (default: \code{"darkgrey"}).
The color is applied only when ANSI color support is available
(see \code{\link[crayon:has_color]{crayon::has_color()}}).}

\item{align_left_cols}{Integer vector of column indices to left-align.
Defaults to \code{c(1, 2)} for frequency tables (Category + Values).}

\item{...}{Additional arguments (currently ignored).}
}
\value{
A single character string containing the full ASCII-formatted table,
suitable for direct printing with \code{cat()}.
}
\description{
Low-level internal function that constructs a visually aligned ASCII table
from a \code{data.frame}.
It supports Unicode characters, ANSI colors, dynamic width adjustment,
left/right alignment, and spacing control.
This function is primarily used internally by higher-level wrappers such as
\code{\link[=spicy_print_table]{spicy_print_table()}} or \code{\link[=print.spicy_freq_table]{print.spicy_freq_table()}}.
}
\details{
\code{build_ascii_table()} is the rendering engine that produces the aligned text
layout of \strong{spicy-formatted tables}.
It automatically detects cell widths (including colored text), inserts Unicode
separators, and applies padding for different display modes (\code{"compact"},
\code{"normal"}, \code{"wide"}).

For most users, this function should not be called directly. Instead, use
\code{\link[=spicy_print_table]{spicy_print_table()}} which adds headers, notes, and alignment logic
automatically.
}
\examples{
# Internal usage example (for developers)
df <- data.frame(
  Category = c("Valid", "", "Missing", "Total"),
  Values = c("Yes", "No", "NA", ""),
  Freq. = c(12, 8, 1, 21),
  Percent = c(57.1, 38.1, 4.8, 100.0)
)

cat(build_ascii_table(df, padding = "compact"))

}
\seealso{
\code{\link[=spicy_print_table]{spicy_print_table()}} for a user-facing wrapper that adds titles and notes.
}
\keyword{internal}
