% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cross_tab.R
\name{cross_tab}
\alias{cross_tab}
\title{Cross-tabulation}
\usage{
cross_tab(
  data,
  x,
  y = NULL,
  by = NULL,
  weights = NULL,
  rescale = FALSE,
  percent = c("none", "column", "row"),
  include_stats = TRUE,
  correct = FALSE,
  simulate_p = FALSE,
  simulate_B = 2000,
  digits = NULL,
  styled = TRUE,
  show_n = TRUE
)
}
\arguments{
\item{data}{A data frame. Alternatively, a vector when using the
vector-based interface.}

\item{x}{Row variable (unquoted).}

\item{y}{Column variable (unquoted). Mandatory; for one-way tables, use \code{\link[=freq]{freq()}}.}

\item{by}{Optional grouping variable or expression. Can be a single variable
or a combination of multiple variables (e.g. \code{interaction(vs, am)}).}

\item{weights}{Optional numeric weights.}

\item{rescale}{Logical. If TRUE, rescales weights so total weighted N matches raw N (default FALSE).}

\item{percent}{One of \code{"none"}, \code{"row"}, \code{"column"}.}

\item{include_stats}{Logical; compute Chi-squared and Cramer's V (default TRUE).}

\item{correct}{Logical; apply Yates continuity correction to the Chi-squared
test. Only applicable to 2x2 tables. Default is FALSE.}

\item{simulate_p}{Logical; use Monte Carlo p-value simulation (default FALSE).}

\item{simulate_B}{Integer; number of replicates for Monte Carlo (default 2000).}

\item{digits}{Number of decimals (default 1 for percentages, 0 for counts).}

\item{styled}{Logical; if TRUE, returns a "spicy_cross_table" object (for printing).}

\item{show_n}{Logical; if TRUE, adds marginal N totals when percent != "none".}
}
\value{
A \code{data.frame}, list of data.frames, or \code{spicy_cross_table} object.
When \code{by} is used, returns a \code{spicy_cross_table_list}.
}
\description{
Computes a two-way cross-tabulation with optional weights, grouping
(including combinations of multiple variables), percentage displays,
and inferential statistics.

\code{cross_tab()} produces weighted or unweighted contingency tables with
row or column percentages, optional grouping via \code{by}, and associated
Chi-squared tests with Cramer's V and diagnostic information.

Both \code{x} and \code{y} variables are required. For one-way frequency tables,
use \code{\link[=freq]{freq()}} instead.
}
\section{Global Options}{


The function recognizes the following global options that modify its default behavior:



The function recognizes the following global options that modify its default behavior:
\itemize{
\item \strong{\code{options(spicy.percent = "column")}}
Sets the default percentage mode for all calls to \code{cross_tab()}.
Valid values are \code{"none"}, \code{"row"}, and \code{"column"}.
Equivalent to setting \code{percent = "column"} (or another choice) in each call.
\item \strong{\code{options(spicy.simulate_p = TRUE)}}
Enables Monte Carlo simulation for all Chi-squared tests by default.
Equivalent to setting \code{simulate_p = TRUE} in every call.
\item \strong{\code{options(spicy.rescale = TRUE)}}
Automatically rescales weights so that total weighted N equals the raw N.
Equivalent to setting \code{rescale = TRUE} in each call.
}

These options are convenient for users who wish to enforce consistent behavior
across multiple calls to \code{cross_tab()} and other spicy table functions.
They can be disabled or reset by setting them to \code{NULL}:
\code{options(spicy.percent = NULL, spicy.simulate_p = NULL, spicy.rescale = NULL)}.

Example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(spicy.simulate_p = TRUE, spicy.rescale = TRUE)
cross_tab(mtcars, cyl, gear, weights = mtcars$mpg)
}\if{html}{\out{</div>}}
}

\examples{
# Basic crosstab
cross_tab(mtcars, cyl, gear)

# Weighted (rescaled)
cross_tab(mtcars, cyl, gear, weights = mtcars$mpg, rescale = TRUE)

# Grouped
cross_tab(mtcars, cyl, gear, by = am)

# Grouped by an interaction
cross_tab(mtcars, cyl, gear, by = interaction(vs, am))

# Set default percent mode globally
options(spicy.percent = "column")

# Now this will display column percentages by default
cross_tab(mtcars, cyl, gear)

# Reset to default behavior
options(spicy.percent = NULL)

# 2x2 table with Yates correction
cross_tab(mtcars, vs, am, correct = TRUE)

}
