% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sppDistMatrix.R
\name{sppDistMatrix}
\alias{sppDistMatrix}
\title{Mean intra- and inter-specific distance matrix}
\usage{
sppDistMatrix(distobj, sppVector)
}
\arguments{
\item{distobj}{A distance matrix.}

\item{sppVector}{The species vector (see \code{\link{sppVector}}).}
}
\value{
A square matrix with dimensions \code{length(sppVector)}. It
contains the mean intra specific distances down the diagonal, and the mean
pairwise distance between the species in the triangles. The two triangles
are identical.
}
\description{
Creates a matrix giving the mean distances within and between species.
}
\examples{

data(dolomedes)
doloDist <- ape::dist.dna(dolomedes)
doloSpp <- substr(dimnames(dolomedes)[[1]], 1, 5)

sppDistMatrix(doloDist, doloSpp)


}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Barcoding}
