% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{get_track_data}
\alias{get_track_data}
\title{Meta-data of a track}
\usage{
get_track_data(field, track_index = current_track_index())
}
\arguments{
\item{field}{Name of the field, see the \strong{Details} section.}

\item{track_index}{The index of the track.}
}
\value{
A numeric vector (of length one or two) for the corresponding field.
}
\description{
Meta-data of a track
}
\details{
There are following fields that can be retrieved for a given track:
\itemize{
\item \code{ymin}: Minimal value on the y-axis.
\item \code{ymax}: Maximal value on the y-axis.
\item \code{ycenter}: \code{(ymin + ymax)/2}.
\item \code{ylim}: \code{c(ylim, ymax)}.
\item \code{yrange}: \code{ymax - ymin}.
\item \code{height}: Height of the track, measured as the fraction of the distance between two neighbouring spiral loops.
}

It is more suggested to directly use \code{\link{TRACK_META}} to retrieve meta data for the current track.
}
