% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tree_evaluation.R
\name{predictCoeffs}
\alias{predictCoeffs}
\title{Predict spline coefficients for a testset using a spline tree}
\usage{
predictCoeffs(tree, testset = tree$parms$flat_data)
}
\arguments{
\item{tree}{A model created with splineTree()}

\item{testset}{The dataset to predict coefficients for. Default is the flattened dataset used to make the tree.}
}
\value{
A matrix of spline coefficients. The dimension of the matrix is the degrees of freedom of
the spline by the number of units in the test set. The ith column of the matrix holds the predicted
coefficients for the ith row in the testset.
}
\description{
Returns a matrix of spline coefficients for each observation in the testset. If no testset is provided,
returns predicted coefficients for the individuals in training set; in this case, the columns of the
returned predictions correspond to the rows of the flattened training dataset (found in tree$parms$flat_data).
}
\details{
importFrom treeClust rpart.predict.leaves
}
\examples{
\donttest{
split_formula <- ~HISP + WHITE + BLACK + SEX + Num_sibs + HGC_FATHER + HGC_MOTHER
tree <- splineTree(split_formula, BMI~AGE, idvar = "ID",
   data = nlsySample, degree = 1, df = 3,
   intercept = TRUE, cp = 0.005)
}
preds <- predictCoeffs(tree)
}
