% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/splithalf_multiverse.R
\name{splithalf.multiverse}
\alias{splithalf.multiverse}
\title{Multiverse of data processing decisions on internal consistency reliability estimates.}
\usage{
splithalf.multiverse(input, specifications)
}
\arguments{
\item{input}{splithalf object or list of splithalf objects}

\item{specifications}{list of data processing specifications}
}
\value{
Returns a multiverse object containing the reliability estimates and dataframes from all data processing specifications provided
}
\description{
This function enables the user to run a multiverse of data processing options and extract the resulting (internal consistency) reliability estimates generated by splithalf. The user specifies a set of data processing decisions and passes this to the function, along with a splithalf object. The output can then be explored and plotted as desired.
}
\details{
The (unofficial) function version name is "This function will let you get honey from a hornets nest"
}
\examples{
\dontrun{
## see online documentation for examples
https://github.com/sdparsons/splithalf
## also see https://psyarxiv.com/y6tcz

## example simulated data
n_participants = 60 ## sample size
n_trials = 80
n_blocks = 2
sim_data <- data.frame(participant_number = rep(1:n_participants,
                       each = n_blocks * n_trials),
                       trial_number = rep(1:n_trials,
                       times = n_blocks * n_participants),
                       block_name = rep(c("A","B"),
                       each = n_trials,
                       length.out = n_participants * n_trials * n_blocks),
                       trial_type = rep(c("congruent","incongruent"),
                       length.out = n_participants * n_trials * n_blocks),
                       RT = rnorm(n_participants * n_trials * n_blocks,
                       500,
                       200),
                       ACC = 1)

## specify several data processing decisions
specifications <- list(RT_min = c(0, 100, 200),
                       RT_max = c(1000, 2000),
                       averaging_method = c("mean", "median"))
## run splithalf, and save the output
difference <- splithalf(data = sim_data,
                        outcome = "RT",
                        score = "difference",
                        conditionlist = c("A"),
                        halftype = "random",
                        permutations = 5000,
                        var.RT = "RT",
                        var.condition = "block_name",
                        var.participant = "participant_number",
                        var.compare = "trial_type",
                        var.ACC = "ACC",
                        compare1 = "congruent",
                        compare2 = "incongruent",
                        average = "mean")

## run splithalf.multiverse to perform the multiverse of data processing
## and reliability estimation
multiverse <- splithalf.multiverse(input = difference,
                                   specifications = specifications)

## can be plot with:
multiverse.plot(multiverse = multiverse,
                title = "README multiverse")
}
}
