% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/randcov_params.R
\name{randcov_params}
\alias{randcov_params}
\title{Create a random effects covariance parameter object}
\usage{
randcov_params(..., nm)
}
\arguments{
\item{...}{A named vector (or vectors) whose names represent the name of each random
effect and whose values represent the variance of each random effect. If
unnamed, \code{nm} is used to set names.}

\item{nm}{A character vector of names to assign to \code{...}.}
}
\value{
A named numeric vector of random effect covariance parameters.
}
\description{
Create a random effects covariance parameter object for use with other
functions.
}
\details{
Names of the random effects should match eligible names given to
\code{random} in modeling functions. While with the \code{random}
argument to these functions, an
intercept is implicitly assumed, with \code{randcov_params}, an intercept must be
explicitly specified. That is, while with \code{random}, \code{x | group}
is shorthand for \code{(1 | group) + (x | group)}, with \code{randcov_params},
\code{x | group} implies just \code{x | group}, which means that if \code{1 | group}
is also desired, it must be explicitly specified.
}
\examples{
randcov_params(group = 1, subgroup = 2)
randcov_params(1, 2, nm = c("group", "subgroup"))
# same as
randcov_params("1 | group" = 1, "1 | subgroup" = 2)
}
