% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/search_artists.R
\name{search_artists}
\alias{search_artists}
\title{Search artists based on given input}
\usage{
search_artists(
  artist_name,
  output = c("tidy", "raw", "id"),
  limit = 20,
  offset = 0,
  token = my_token
)
}
\arguments{
\item{artist_name}{Required. Get Spotify Catalog information about artists that match this input.}

\item{output}{Type of output to return from the request. Default: tidy.}

\item{limit}{Maximum number of results to return. Should be between 1 and 50. Default: 20.}

\item{offset}{The index of the first result to return. Default: 0.}

\item{token}{A valid access token from the Spotify Accounts service: see
\url{https://developer.spotify.com/documentation/general/guides/authorization-guide/} for details. Default: my_token.}
}
\value{
Default: returns a tidy dataframe with a selection of the response. Alternatively, when output is set to raw, it returns the raw output from the
request, or When output is set to id, it returns only the id.
}
\description{
Connects with the Spotify API and returns output from the href \url{https://api.spotify.com/v1/search/}
}
