% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itsamp.R
\name{itsamp}
\alias{itsamp}
\title{Inverse Transform Sampling To Generate Time-to-event Data From Parametric Models}
\usage{
itsamp(
  n,
  beta = c(2, -1),
  event_scale = 10,
  censor_scale = 4,
  features = data.frame(x1 = rnorm(n, 0), x2 = rnorm(n, 0)),
  shape = 2,
  model = c("ph", "po", "aft"),
  dist = c("weibull", "llogis"),
  censor = TRUE
)
}
\arguments{
\item{n}{integer; sample size}

\item{beta}{vector of regression coefficients}

\item{event_scale, censor_scale}{event and censoring scale parameters}

\item{features}{matrix of features (columns)}

\item{shape}{event and censoring distribution shape}

\item{model}{either "ph" (default) or "aft" for weibull and
"po" or "aft" for log-logistic distribution}

\item{dist}{"weibull" or "llogis"}

\item{censor}{logical; if `TRUE`, censoring is required, that is
mean(status) > 0}
}
\value{
data.frame of `ncol(x) +2` columns in which the
 survival times are the response variable denoted by `y`,
  `status` indicates failure (0 = failure) and the features
  are appended to the next columns.
}
\description{
Random survival times generation for the weibull or
 log-logistic distributions with parameters `scale` and `shape`.
}
\details{
sim_surv returns weibull (log-logistic) randomly
generated survival times. According to Collett (2003), the
accelerated failure time model encompasses a wide variety of parametric
models, including weibull and log-logistic models.
}
\examples{
rows <- 200

categorical <- rbinom(rows, size = 3, prob = .5)
x <- data.frame(numerical = rnorm(rows),
           cat0 = as.numeric(categorical == 0),
           cat1 = as.numeric(categorical == 1),
           cat2 = as.numeric(categorical == 2),
           cat3 = as.numeric(categorical == 3))

newdata <- itsamp(n = rows, beta = c(1, -2, .5, .1, 1),
  features = x, model = 'ph', dist = 'weibull')

}
\seealso{
\code{\link[spsurv]{spbp}}
}
