% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/slu_date_to_sqlite.R
\name{slu_date_to_sqlite}
\alias{slu_date_to_sqlite}
\title{Converts dates to the numeric values as which they would be stored on SQLite}
\usage{
slu_date_to_sqlite(date_r)
}
\arguments{
\item{date_r}{dates as returned by as.Date() in R}
}
\value{
integers that correspond to the numbers that are stored on SQLite when \code{DBI:dbWriteTable} is used
}
\description{
Converts dates to the numeric values as which they would be stored on SQLite
}
\examples{

con <- DBI::dbConnect(RSQLite::SQLite(), ":memory:")
data <- data.frame(
    date = as.Date("2021-09-19")
)
DBI::dbWriteTable(conn = con, name = "dates", value = data )
data_from_bd <- dplyr::tbl(src = con, "dates") \%>\%  dplyr::collect()
data_with_sqlite_dates <- data \%>\%
dplyr::mutate(
    date = slu_date_to_sqlite(date)
)
print(data_from_bd)
print(data_with_sqlite_dates)
DBI::dbDisconnect(con)


}
