#' INSERT INTO statement.
#'
#' @examples
#' # Simple INSERT statement:
#' fields <- c('author', 'title', 'year')
#' insert <- StmtInsert$new(tabl = 'books', fields = make_fields(fields))
#'
#' @import R6
#' @include Statement.R
#' @export
StmtInsert <- R6::R6Class("StmtInsert",
  inherit = Statement,
  public = list(

    #' @description
    #' Initializer.
    #' @param tabl A table name.
    #' @param fields An instance of ExprListFields
    #' @return Nothing.
    initialize = function(tabl, fields) {
      chk::chk_is(fields, "ExprListFields")
      chk::chk_string(tabl)
      private$fields <- fields
      private$table <- tabl
    },

    #' @description
    #' Generates the list of tokens representing this statement.
    #' @return A list of Token objects.
    getTokens = function() {
      tokens <- list(.insert, .spc, .into, .spc,
                     TokenIdentifier$new(private$table), .spc)
      tokens <- c(tokens, private$fields$getTokens())
      return(tokens)
    }
  ),
  private = list(
    table = NULL,
    fields = NULL
  )
)
