% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/csiro_lead_marine.R
\docType{data}
\name{csiro_lead_marine}
\alias{csiro_lead_marine}
\title{Species Sensitivity Data for lead_marine}
\format{
An object of class \code{tbl_df} (inherits from \code{tbl},
\code{data.frame}) with 16 rows and 7 columns.
}
\usage{
csiro_lead_marine
}
\description{
Species Sensitivity Data provided by the Commonwealth Scientific and
Industrial Research Organisation of Australia for lead in marine water.
}
\details{
These data were sourced from:
\insertRef{Batley}{ssddata}

The columns are as follows:

\describe{
\item{Conc}{The chemical concentration (dbl).}
\item{Duration}{Test duration (chr).}
\item{Group}{Taxonomic grouping information (chr).}
\item{Life_stage}{Life stage of the test organism (chr).}
\item{Species}{The species names name (chr).}
\item{Test_endpoint}{Endpoint statistic, EC10, NEC etc (chr).}
\item{Toxicity_measure}{Type of toxicity measure used (chr).}

Where toxicity measure is not a chronic NEC, EC10 or NOEC value,
concentration has been converted using the appropriate default ratio, as
follows: 10 from acute EC50/LC50 to chronic EC10; 5 from chronic EC50 to
EC10; 2.5 from LOEC to EC10. Please see the primary reference material for
more information.

All concentration data are ug/L unless otherwise stated. }
}
\examples{

print(csiro_lead_marine, n=Inf)

}
\keyword{datasets}
