% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distributionFuns.R
\name{generate_skewed_t}
\alias{generate_skewed_t}
\title{Generate random samples from the skewed t-distribution}
\usage{
generate_skewed_t(n, nu, lambda, bc_M)
}
\arguments{
\item{n}{An integer specifying the number of random observations to generate. Must be a positive integer.}

\item{nu}{A numeric scalar specifying the degrees of freedom parameter for the skewed \emph{t}-distribution. Must be greater than 2.}

\item{lambda}{A numeric scalar specifying the skewness parameter for the skewed \emph{t}-distribution. Must be between \eqn{-1} and \eqn{1}.}

\item{bc_M}{An optional numeric scalar specifying the bounding constant \eqn{M} used in the acceptance-rejection algorithm.
If not provided, it is computed using \code{\link{bounding_const_M}} with the given \code{nu} and \code{lambda}.}
}
\value{
A numeric vector of length \code{n} containing random observations from the skewed \emph{t}-distribution with
  parameters \code{nu} and \code{lambda}.
}
\description{
\code{generate_skewed_t} generates \code{n} random observations from the univariate skewed \emph{t}-distribution
 described in Hansen (1994) using the acceptance-rejection sampling method.
}
\details{
The function implements the acceptance-rejection algorithm to generate random samples from the skewed \emph{t}-distribution.
  The proposal distribution used is a standard \emph{t}-distribution with degrees of freedom \code{proposal_nu}, which is set to \eqn{3}
  when \code{nu > 3} to ensure heavier tails and accommodate the skewness of the target distribution.

  If \code{bounding_const_M} is not provided, it is calculated using the \code{\link{bounding_const_M}} function. It is important that
  the same proposal distribution is used in both the computation of \code{bounding_const_M} and the acceptance-rejection sampling
  algorithm to ensure correctness.
}
\references{
\itemize{
   \item Hansen B.E. 1994. Autoregressive Conditional Density estimation. \emph{Journal of Econometrics}, \strong{35}:3, 705-730.
 }
}
\keyword{internal}
