% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers_catboost.R
\name{catboost_predict}
\alias{catboost_predict}
\title{Predict based on the model}
\usage{
catboost_predict(model, pool, prediction_type = "Probability", ...)
}
\arguments{
\item{model}{The trained model.}

\item{pool}{The dataset to predict on.}

\item{prediction_type}{Prediction type.}

\item{...}{Additional parameters.}
}
\value{
Predicted values.
}
\description{
Predict based on the model
}
\examples{
\dontshow{if (is_installed_catboost()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sim_data <- msaenet::msaenet.sim.binomial(
  n = 100,
  p = 10,
  rho = 0.6,
  coef = rnorm(5, mean = 0, sd = 10),
  snr = 1,
  p.train = 0.8,
  seed = 42
)

x_train <- catboost_load_pool(data = sim_data$x.tr, label = sim_data$y.tr)
x_test <- catboost_load_pool(data = sim_data$x.te, label = NULL)

fit <- catboost_train(
  x_train,
  NULL,
  params = list(
    loss_function = "Logloss",
    iterations = 100,
    depth = 3,
    logging_level = "Silent"
  )
)

catboost_predict(fit, x_test)
\dontshow{\}) # examplesIf}
}
