% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.stackgbm}
\alias{predict.stackgbm}
\title{Make predictions from a stackgbm model object}
\usage{
\method{predict}{stackgbm}(object, newx, threshold = 0.5, classes = c(1L, 0L), ...)
}
\arguments{
\item{object}{A stackgbm model object.}

\item{newx}{New predictor matrix.}

\item{threshold}{Decision threshold. Default is 0.5.}

\item{classes}{The class encoding vector of the predicted outcome.
The naming and order will be respected.}

\item{...}{Unused.}
}
\value{
A list of two vectors presenting the predicted classification
probabilities and predicted response.
}
\description{
Make predictions from a stackgbm model object
}
\examples{
\dontshow{if (is_installed_xgboost() && is_installed_lightgbm() && is_installed_catboost()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
sim_data <- msaenet::msaenet.sim.binomial(
  n = 1000,
  p = 50,
  rho = 0.6,
  coef = rnorm(25, mean = 0, sd = 10),
  snr = 1,
  p.train = 0.8,
  seed = 42
)

params_xgboost <- structure(
  list("nrounds" = 200, "eta" = 0.05, "max_depth" = 3),
  class = c("cv_params", "cv_xgboost")
)
params_lightgbm <- structure(
  list("num_iterations" = 200, "max_depth" = 3, "learning_rate" = 0.05),
  class = c("cv_params", "cv_lightgbm")
)
params_catboost <- structure(
  list("iterations" = 100, "depth" = 3),
  class = c("cv_params", "cv_catboost")
)

fit <- stackgbm(
  sim_data$x.tr,
  sim_data$y.tr,
  params = list(
    params_xgboost,
    params_lightgbm,
    params_catboost
  )
)

predict(fit, newx = sim_data$x.te)
\dontshow{\}) # examplesIf}
}
