% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ConnectionDB.R
\docType{class}
\name{ConnectionDB-class}
\alias{ConnectionDB-class}
\title{ConnectionDB class}
\value{
connection an S4 object of class connectionDB
}
\description{
ConnectionDB class
}
\section{Slots}{

\describe{
\item{\code{dbname}}{name of the database, length 1}

\item{\code{host}}{host default "localhost", length 1}

\item{\code{port}}{port of the database default "5432", length 1}

\item{\code{user}}{user of the database, length 1}

\item{\code{password}}{password for the datatbase, length 1}

\item{\code{silent}}{A "logical" stating if the program returns output to the user}

\item{\code{status}}{Can be -1 or string}

\item{\code{connection}}{Could be both string or S3}
}}

\note{
Mother class for connection, opens the connection but does not shut it
}
\examples{
##this wont be run as the user need to manually configure the connection before using it
\dontrun{
object <- new("ConnectionDB")
object@dbname <- c("bd_contmig_nat","test")
object@host <- 		"localhost"
object@port <-		"5432"
object@user <-		"myuser"
object@password <-		"mypassword"
object@silent=FALSE
object <- connect(object)
pool::dbGetInfo(object@connection)
pool::poolClose(object@connection)
}
}
\author{
Cedric Briand \email{cedric.briand@eptb-vilaine.fr}
}
