% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SSLL.R
\name{SSLL}
\alias{SSLL}
\alias{LL4.fun}
\alias{LL3.fun}
\alias{LL2.fun}
\alias{NLS.LL4}
\alias{NLS.LL3}
\alias{NLS.LL2}
\title{Log-logistic equation}
\usage{
LL4.fun(predictor, b, c, d, e)
LL3.fun(predictor, b, d, e)
LL2.fun(predictor, b, e)
NLS.LL4(predictor, b, c, d, e)
NLS.LL3(predictor, b, d, e)
NLS.LL2(predictor, b, e)
}
\arguments{
\item{predictor}{a numeric vector of values at which to evaluate the model}

\item{b}{model parameter (slope at inflection point)}

\item{c}{model parameter (lower asymptote)}

\item{d}{model parameter (higher asymptote)}

\item{e}{model parameter (abscissa at inflection point)}
}
\value{
All these functions return a numeric value
}
\description{
These functions provide the loglogistic equation, that has a
symmetric sygmoidal shape over the logarithm of time and it has been used
for bioassay work. These functions provide the 4-, 3- and 2-parameter
equations (LL4.fun(), LL3.fun() and LL2.fun()) as well as the self-starters
for the \code{\link{nls}} function (NLS.LL4(), NLS.LL3() and NLS.LL2() )
}
\details{
These functions provide the log-logistic equation for bioassay work
This equation (4-parameters) is parameterised as:
\deqn{ f(x) = c + \frac{d - c}{\exp ( 1 + \exp ( - b\,(\log(x) - \log(e))))} }
For the 3- and 2-parameters model, c is equal to 0, while for the 2-parameter
model d is equal to 1.
}
\examples{
dataset <- getAgroData("brassica")

model <- nls(FW ~ NLS.LL4(Dose, b, c, d, e), data = dataset)
model <- nls(FW ~ NLS.LL3(Dose, b, d, e), data = dataset)
model <- nls(FW/max(FW) ~ NLS.LL2(Dose, b, e), data = dataset)
summary(model)

}
\references{
Ratkowsky, DA (1990) Handbook of nonlinear regression models. New York (USA): Marcel Dekker Inc.

Onofri, A. (2020). A collection of self-starters for nonlinear regression in R. See: \url{https://www.statforbiology.com/2020/stat_nls_usefulfunctions/}

Ritz, C., Jensen, S.M., Gerhard, D., Streibig, J.C., 2019. Dose-response analysis using R, CRC Press. ed. USA.
}
\author{
Andrea Onofri
}
