% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{countValid}
\alias{countValid}
\title{Count valid observations per time point for a given trait}
\usage{
countValid(TP, trait)
}
\arguments{
\item{TP}{An object of class TP.}

\item{trait}{A character string indicating the trait for which valid
observations should be counted.}
}
\value{
A named numerical vector with he number of valid observations per
time point .
}
\description{
Count valid observations per time point for a given trait.
}
\examples{
## Create a TP object containing the data from the Phenovator.
phenoTP <- createTimePoints(dat = PhenovatorDat1,
                            experimentName = "Phenovator",
                            genotype = "Genotype",
                            timePoint = "timepoints",
                            repId = "Replicate",
                            plotId = "pos",
                            rowNum = "y", colNum = "x",
                            addCheck = TRUE,
                            checkGenotypes = c("check1", "check2",
                                               "check3", "check4"))
## Count valid observations for EffpsII per time point.
validPheno <- countValid(phenoTP, trait = "EffpsII")
head(validPheno)

}
