% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{expert2}
\alias{expert2}
\title{Sensory Evaluation Data from Expert 2}
\format{
A data frame with 6 rows (Wine1–Wine6) and 4 sensory attributes:
\describe{
\item{red_fruit}{Intensity of red fruit aromas.}
\item{roasted}{Intensity of roasted or toasted notes.}
\item{vanillin}{Perceived vanilla-related notes.}
\item{woody}{Intensity of woody/aged aromas.}
}
}
\usage{
data(expert2)
}
\description{
This dataset contains the evaluations provided by Expert 2 for the same six wine samples.
Unlike Expert 1, this expert uses four sensory descriptors:
\emph{red_fruit}, \emph{roasted}, \emph{vanillin}, and \emph{woody}.
The dataset demonstrates how experts may differ in terminology and profiling,
and it is commonly used in STATIS, MFA, and other multitable comparison techniques.
}
\examples{
data(expert2)
expert2

}
\references{
Abdi, H., & Valentin, D. (2007). The STATIS method. Encyclopedia of measurement and statistics, 955-962.
}
\keyword{datasets}
