% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_statis_dual.R
\name{select.super.variables}
\alias{select.super.variables}
\title{Select and prepare a subset of variables from a supervision matrix}
\usage{
select.super.variables(superv, ET, ETCal)
}
\arguments{
\item{superv}{A numeric matrix or data frame where each row corresponds to a variable and columns represent coordinates (\code{res$supervariables}).}

\item{ET}{A character vector containing the full list of expected variable names (\code{res$vars.names}).}

\item{ETCal}{A character vector containing the subset of variables to be selected.}
}
\value{
A data frame with two columns:
\itemize{
\item \code{x}: first coordinate (e.g., PC1)
\item \code{y}: second coordinate (e.g., PC2)
}
Row names correspond to the selected variables defined in \code{ETCal}.
}
\description{
This function selects a predefined subset of variables (\code{ETCal}) from a
supervision matrix (\code{superv}), checks dimension consistency, verifies
missing variables, and constructs a clean data frame containing the first two
coordinates typically used for PCA or STATIS correlation plots.
}
\details{
The function performs the following steps:
\enumerate{
\item Checks that the number of rows in \code{superv} matches the length of \code{ET}.
\item Assigns the row names of \code{superv} using \code{ET}.
\item Identifies whether any variables in \code{ETCal} are missing in \code{superv};
missing variables trigger a warning.
\item Creates an ordered list of valid variables (\code{ETCal_ok}) based on their presence in \code{superv}.
\item Extracts the corresponding rows from \code{superv} and constructs a data frame with columns \code{x} and \code{y}.
}
}
\examples{
data(Tuis5_95, Tuis5_96, Tuis5_97, Tuis5_98)
labels <- c("95","96","97","98")

res <- statis.dual(list(Tuis5_95, Tuis5_96, Tuis5_97, Tuis5_98), labels.tables = labels)

ETCal <- c("Ph","Temp","DBO","ST","PO4","NO3","POD","Cal")

df_selected <- select.super.variables(res$supervariables, res$vars.names, ETCal)

}
