% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych3.R
\name{ci.pairs.prop.bs}
\alias{ci.pairs.prop.bs}
\title{Bonferroni confidence intervals for all pairwise proportion differences
in a between-subjects design}
\usage{
ci.pairs.prop.bs(alpha, f, n)
}
\arguments{
\item{alpha}{alpha level for simultaneous 1-alpha confidence}

\item{f}{vector of frequency counts of participants who have the attribute}

\item{n}{vector of sample sizes}
}
\value{
Returns a matrix with the number of rows equal to the number
of pairwise comparisons. The columns are:
\itemize{
\item Estimate - adjusted estimate of proportion difference
\item SE - adjusted standard error
\item z - z test statistic
\item p - two-sided p-value
\item LL - lower limit of the adjusted Wald confidence interval
\item UL - upper limit of the adjusted Wald confidence interval
}
}
\description{
Computes adjusted Wald confidence intervals for all pairwise differences
of population proportions in a between-subjects design using a Bonferroni
adjusted alpha level.
}
\examples{
f <- c(111, 161, 132)
n <- c(200, 200, 200)
ci.pairs.prop.bs(.05, f, n)

# Should return:
#        Estimate         SE         z            p          LL          UL
# 1 2  -0.2475248 0.04482323 -5.522243 3.346989e-08 -0.35483065 -0.14021885
# 1 3  -0.1039604 0.04833562 -2.150803 3.149174e-02 -0.21967489  0.01175409
# 2 3   0.1435644 0.04358401  3.293968 9.878366e-04  0.03922511  0.24790360


}
\references{
\insertRef{Agresti2000}{statpsych}
}
