% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{fitindices}
\alias{fitindices}
\title{SEM fit indices}
\usage{
fitindices(chi1, df1, chi2, df2, n)
}
\arguments{
\item{chi1}{chi-square test statistic for full model}

\item{df1}{degrees of freedom for full model}

\item{chi2}{chi-square test statistic for reduced model}

\item{df2}{degrees of freedom for reduced model}

\item{n}{sample size}
}
\value{
Returns NFI, adj NFI, CFI, TLI, and RMSEA
}
\description{
Computes the normed fit index (NFI), adjusted normed fit index (adj NFI),
comparative fit index (CFI), Tucker-Lewis fit index (TLI), and root mean
square error of approximation index (RMSEA). Of the first four indices, the
adj NFI index is recommended because it has smaller sampling variability
than CFI and TLI and less negative bias than NFI.
}
\examples{
fitindices(14.21, 10, 258.43, 20, 300)

# Should return:
#        NFI   adj NFI       CFI       TLI      RMSEA
#  0.9450141 0.9837093 0.9823428 0.9646857 0.03746109
 

}
