% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.gen2}
\alias{size.ci.gen2}
\title{Sample size for a confidence interval for the difference of any type of
parameter}
\usage{
size.ci.gen2(alpha, se, n0, w, R)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{se}{standard error of parameter estimate from prior/pilot study}

\item{n0}{sample size of prior/pilot study}

\item{w}{desired confidence interval width}

\item{R}{n2/n1 ratio}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size required to estimate a difference in population
parameters with desired precision in a 2-group design using a standard
error for a parameter estimate from a prior or pilot study. This function
can be used with any type of parameter where the standard error of the
parameter estimate is a function of the square root of the sample size
(most parameter estimates have this property). This function also assumes
that the sampling distribution of the parameter estimate is approximately
normal in large samples. Set R = 1 for equal sample sizes.
}
\examples{
size.ci.gen2(.05, .175, 30, .8, 1)

# Should return:
# n1  n2
# 45  45
 

}
