% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.mape}
\alias{size.ci.mape}
\title{Sample size for a mean absolute prediction error confidence interval}
\usage{
size.ci.mape(alpha, mape, s, w)
}
\arguments{
\item{alpha}{alpha value for 1-alpha confidence}

\item{mape}{mean absolute prediction error planning value}

\item{s}{number of predictor variables}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a population mean absolute
prediction error for a general linear model with desired confidence interval
precision. Setting s = 0 gives the sample size requirement for a mean absolute
deviation in a one-group design. This function assumes that the prediction
errors have an approximate normal distribution.
}
\examples{
size.ci.mape(.05, 4.5, 5, 2)

# Should return:
# Sample size
#          57
 

}
