% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych2.R
\name{size.ci.spear2}
\alias{size.ci.spear2}
\title{Sample size for a 2-group Spearman correlation difference confidence
interval}
\usage{
size.ci.spear2(alpha, cor1, cor2, w)
}
\arguments{
\item{alpha}{alpha level for 1-alpha confidence}

\item{cor1}{Spearman correlation planning value for group 1}

\item{cor2}{Spearman correlation planning value for group 2}

\item{w}{desired confidence interval width}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required to estimate a difference in population
Spearman correlations with desired confidence interval precision in a 2-group
design. Set the correlation planning values to the smallest absolute values
within their plausible ranges for a conservatively large sample size.
}
\examples{
size.ci.spear2(.05, .8, .5, .2)

# Should return:
# Sample size per group
#                   314
 

}
\references{
\insertRef{Bonett2000}{statpsych}
}
