% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.equiv.mean2}
\alias{size.equiv.mean2}
\title{Sample size for a 2-group mean equivalence test}
\usage{
size.equiv.mean2(alpha, pow, var, es, h)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{var}{planning value of average within-group variance}

\item{es}{planning value of mean difference}

\item{h}{upper limit for range of practical equivalence}
}
\value{
Returns the required sample size for each group
}
\description{
Computes the sample size in each group (assuming equal sample sizes)
required to perform an equivalence test for the difference in population
means with desired power in a 2-group design. The value of h specifies a
range of practical equivalence, -h to h, for the difference in population
means. The planning value for the absolute mean difference must be less
than h.  Equivalence tests often require a very large sample size.
Equivalence tests usually use 2 x alpha rather than alpha (e.g., use
alpha = .10 rather alpha = .05). Set the variance planning value to the
largest value within a plausible range for a conservatively large sample
size.
}
\examples{
size.equiv.mean2(.10, .80, 15, 2, 4)

# Should return:
# Sample size per group 
#                    50
 

}
