% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/statpsych1.R
\name{size.test.sign}
\alias{size.test.sign}
\title{Sample size for a 1-group sign test}
\usage{
size.test.sign(alpha, pow, p)
}
\arguments{
\item{alpha}{alpha level for hypothesis test}

\item{pow}{desired power}

\item{p}{planning value of proportion}
}
\value{
Returns the required sample size
}
\description{
Computes the sample size required for a 1-group sign test with desired
power (see size.test.sign.ps for a paired-samples sign test). The Sign
test is a test of the null hypothesis that the population median is equal
to some specified value. This null hypothesis can also be expressed in
terms of the proportion of scores in the population that are greater than
the hypothesized population median value. Under the null hypothesis, the
population proportion is equal to .5. This function requires a planning
value of the population proportion.
}
\examples{
size.test.sign(.05, .90, .3)

# Should return:
# Sample size
#          67
 

}
