% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample2indp.R
\name{sample2indp}
\alias{sample2indp}
\title{Independent normal data}
\usage{
sample2indp(n , mean = 0, sigma = 1, coefvar = NULL,
            alternative = c("two.sided", "less", "greater"), delta = 0,
            conf.level = 0.95, dec = 2)
}
\arguments{
\item{n}{vector of size of samples.}

\item{mean}{vector of means.}

\item{sigma}{vector of standard deviations.}

\item{coefvar}{an optional vector of coefficients of variation.}

\item{alternative}{a character string specifying the alternative hypothesis for T-Test. meanst be one of ``two.sided`` (default), ``greater`` or ``less``. Can be specified just the initial letter.}

\item{delta}{true value of the difference in means.}

\item{conf.level}{confidence level of the interval. It determines level of significance for comparing variances.}

\item{dec}{number of decimals for observations.}
}
\value{
A list containing the following components:

\itemize{

 \item \code{Data}: a data frame containing the samples created.


 \item \code{T.Test}: a t-test of the samples.

 \item \code{Power}: power of the test.

}
}
\description{
Generates two normal independent samples. It also provides Cohen's effect and T-Test.
}
\details{
If \code{mean} or \code{sigma} are not specified it's assumed the default values of \code{0} and \code{1}.

   \code{n} is a vector, so it's possible to generate samples with same or different sizes.

   If \code{coefvar} is given, \code{sigma} is omitted. Vector of means cannot have any 0.
}
\examples{
sample2indp(c(10,12),mean = c(2,3),coefvar = c(0.3,0.5), alternative = "less", delta = -1)

sample2indp(8,sigma = c(1,1.5), dec = 3)

}
