% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stabilize_dbl.R
\name{.check_value_dbl}
\alias{.check_value_dbl}
\title{Check double values against min and max values}
\usage{
.check_value_dbl(
  x,
  min_value,
  max_value,
  x_arg = caller_arg(x),
  call = caller_env()
)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{min_value}{\verb{(length-1 numeric)} The lowest allowed value for \code{x}. If
\code{NULL} (default) values are not checked.}

\item{max_value}{\verb{(length-1 numeric)} The highest allowed value for \code{x}. If
\code{NULL} (default) values are not checked.}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}
}
\value{
\code{NULL}, invisibly, if \code{x} passes all checks.
}
\description{
Check double values against min and max values
}
\keyword{internal}
