% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cls_unexported.R
\name{.to_cls_scalar}
\alias{.to_cls_scalar}
\title{Coerce an object to a specific scalar class}
\usage{
.to_cls_scalar(
  x,
  is_rlang_cls_scalar,
  to_cls_fn,
  to_cls_args = list(),
  allow_null = TRUE,
  allow_zero_length = TRUE,
  x_arg = caller_arg(x),
  call = caller_env(),
  x_class = object_type(x)
)
}
\arguments{
\item{x}{The argument to stabilize.}

\item{is_rlang_cls_scalar}{\verb{(function)} An \verb{is_scalar_*()} function from
rlang, used for a fast path if \code{x} is already the right type.}

\item{to_cls_fn}{\verb{(function)} The \verb{to_*()} function to use for coercion.}

\item{to_cls_args}{\code{(list)} A list of additional arguments to pass to
\code{to_cls_fn()}.}

\item{allow_null}{\verb{(length-1 logical)} Is NULL an acceptable value?}

\item{allow_zero_length}{\verb{(length-1 logical)} Are zero-length vectors
acceptable?}

\item{x_arg}{\verb{(length-1 character)} An argument name for x. The automatic
value will work in most cases, or pass it through from higher-level
functions to make error messages clearer in unexported functions.}

\item{call}{\code{(environment)} The execution environment to mention as the
source of error messages.}

\item{x_class}{\verb{(length-1 character)} The class name of \code{x} to use in error
messages. Use this if you remove a special class from \code{x} before checking
its coercion, but want the error message to match the original class.}
}
\value{
\code{x} as a scalar of the target class.
}
\description{
A helper that wraps around a \verb{to_*_scalar()} function to provide a standard
set of checks.
}
\keyword{internal}
