% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stepcount.R
\name{sc_model_params}
\alias{sc_model_params}
\alias{stepcount}
\alias{stepcount_with_model}
\title{Run Stepcount Model on Data}
\usage{
sc_model_params(model_type, pytorch_device)

stepcount(
  file,
  sample_rate = NULL,
  model_type = c("ssl", "rf"),
  model_path = NULL,
  pytorch_device = c("cpu", "cuda:0"),
  verbose = TRUE,
  keep_data = FALSE
)

stepcount_with_model(
  file,
  model_type = c("ssl", "rf"),
  model,
  sample_rate = NULL,
  pytorch_device = c("cpu", "cuda:0"),
  verbose = TRUE,
  keep_data = FALSE
)
}
\arguments{
\item{model_type}{type of the model: either random forest (rf) or
Self-Supervised Learning model (ssl)}

\item{pytorch_device}{device to use for prediction for PyTorch.}

\item{file}{accelerometry file to process, including CSV,
CWA, GT3X, and \code{GENEActiv} bin files}

\item{sample_rate}{the sample rate of the data.  Set to \code{NULL}
for \code{stepcount} to try to guess this}

\item{model_path}{the file path to the model.  If on disk, this can be
re-used and not re-downloaded.  If \code{NULL}, will download to the
temporary directory}

\item{verbose}{print diagnostic messages}

\item{keep_data}{should the data used in the prediction be in the output?}

\item{model}{A model object loaded from \code{sc_load_model}, but
\code{as_python} must be \code{TRUE}}
}
\value{
A list of the results (\code{data.frame}),
summary of the results, adjusted summary of the results, and
information about the data.
}
\description{
Run Stepcount Model on Data
}
\examples{
file = system.file("extdata/P30_wrist100.csv.gz", package = "stepcount")
if (stepcount_check()) {
  out = stepcount(file = file)
  st = out$step_times
}
\dontrun{
  file = system.file("extdata/P30_wrist100.csv.gz", package = "stepcount")
  df = readr::read_csv(file)
  if (stepcount_check()) {
    out = stepcount(file = df)
    st = out$step_times
  }
  if (requireNamespace("ggplot2", quietly = TRUE) &&
      requireNamespace("tidyr", quietly = TRUE) &&
      requireNamespace("dplyr", quietly = TRUE)) {
    dat = df[10000:12000,] \%>\%
      dplyr::select(-annotation) \%>\%
      tidyr::gather(axis, value, -time)
    st = st \%>\%
      dplyr::mutate(time = lubridate::as_datetime(time)) \%>\%
      dplyr::as_tibble()
    st = st \%>\%
      dplyr::filter(time >= min(dat$time) & time <= max(dat$time))
    dat \%>\%
      ggplot2::ggplot(ggplot2::aes(x = time, y = value, colour = axis)) +
      ggplot2::geom_line() +
      ggplot2::geom_vline(data = st, ggplot2::aes(xintercept = time))
  }

}
}
