% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as.lpp.stlpp.R
\name{as.lpp.stlpp}
\alias{as.lpp.stlpp}
\title{Methods for spatio-temporal point patterns on a linear network}
\usage{
\method{as.lpp}{stlpp}(x,...)
}
\arguments{
\item{x}{an object of class \code{\link{stlpp}}}

\item{...}{arguments passed to \code{\link[spatstat.linnet]{as.lpp}}}
}
\value{
An object of class \code{\link[spatstat.linnet]{lpp}}.
}
\description{
This function projects an object of class \code{\link{stlpp}} into a linear network.
}
\details{
This function projects the spatio-temporal point pattern x into its corresponding linear network L which is the corresponding spatial point pattern of x
}
\examples{
 
data(easynet)
x <- runifpointOnLines(40, easynet)
t1 <- sample(1:10, 40, replace = TRUE)
Y <- as.stlpp(x, t = t1, L = easynet)
as.lpp.stlpp(Y)

}
\seealso{
\code{\link{as.stlpp}}, \code{\link[spatstat.linnet]{lpp}}, \code{\link[spatstat.linnet]{as.lpp}}
}
\author{
Mehdi Moradi <m2.moradi@yahoo.com>
}
