% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimizers_free.R
\name{run_adaQN_free}
\alias{run_adaQN_free}
\title{Run adaQN optimizer in free-mode}
\usage{
run_adaQN_free(optimizer, x, step_size)
}
\arguments{
\item{optimizer}{An `adaQN_free` optimizer, for which its last request must have been served. Will be updated in-place.}

\item{x}{Current values of the variables being optimized. Must be a numeric vector. Will be updated in-place.}

\item{step_size}{Step size for the quasi-Newton update.}
}
\value{
A request with the next piece of required information. The output will be a list with the following levels:
\itemize{
   \item{task} Requested task (one of "calc_grad", "calc_fun_val_batch", "calc_grad_big_batch").
   \item{requested_on} Values of `x` at which the requested information must be calculated.
   \item{info} \itemize{
      \item{x_changed_in_run} Whether the `x` vector was updated.
      \item{iteration_number} Current iteration number (in terms of quasi-Newton updates).
      \item{iteration_info} Information about potential problems encountered during the iteration.
   } 
}
}
\description{
Run the next step of an adaQN optimization procedure, after the last requested calculation
has been fed to the optimizer. When run for the first time, there is no request, so the function just
needs to be run on the object as it is returned from function `adaQN_free`.
}
\seealso{
\link{adaQN_free}
}
