#include <Rcpp.h>
#include <math.h>
#include <cmath>

// [[Rcpp::export]]

 Rcpp::List sim_stochcorr(double dt, double S1_0, double S2_0, double mu1, double mu2, double sigma1, double sigma2, Rcpp::NumericVector rho, double iter = 500){
   double n = rho.length();
   Rcpp::NumericMatrix S1(iter,n);
   Rcpp::NumericMatrix S2(iter,n);

   double W_1{0};
   double W_2{0};

   for(int i=0; i<iter; i++){
     for(int j=0; j<n; j++){
       if (j==0){
        W_1=0;
        W_2=0;
        S1(i,j)=S1_0;
        S2(i,j)=S2_0;
       } else {
        W_1 = R::rnorm(0,sqrt(dt));
        W_2 = R::rnorm(0,sqrt(dt));

        S1(i,j)=S1(i,j-1)*exp((mu1-pow(sigma1,2)/2)*(dt)+sigma1*W_1);
        S2(i,j)=S2(i,j-1)*exp((mu2-pow(sigma2,2)/2)*(dt)+sigma2*(rho[j]*W_1+sqrt(1-pow(rho[j],2))*W_2));
       }
     }
   }

  Rcpp::List L = Rcpp::List::create(Rcpp::Named("S1") = S1 , Rcpp::Named("S2") = S2);

  return(L);
 }
