/*
 * Decompiled with CFR 0.152.
 */
package moa.clusterers.kmeanspm;

public class Metric {
    public static double distanceSquared(double[] pointA) {
        double distance = 0.0;
        for (int i = 0; i < pointA.length; ++i) {
            distance += pointA[i] * pointA[i];
        }
        return distance;
    }

    public static double distance(double[] pointA) {
        return Math.sqrt(Metric.distanceSquared(pointA));
    }

    public static double distanceSquared(double[] pointA, double[] pointB, int offsetB) {
        assert (pointA.length == pointB.length + offsetB);
        double distance = 0.0;
        for (int i = 0; i < pointA.length; ++i) {
            double d = pointA[i] - pointB[i + offsetB];
            distance += d * d;
        }
        return distance;
    }

    public static double distance(double[] pointA, double[] pointB, int offsetB) {
        return Math.sqrt(Metric.distanceSquared(pointA, pointB, offsetB));
    }

    public static double distanceSquared(double[] pointA, double[] pointB) {
        assert (pointA.length == pointB.length);
        double distance = 0.0;
        for (int i = 0; i < pointA.length; ++i) {
            double d = pointA[i] - pointB[i];
            distance += d * d;
        }
        return distance;
    }

    public static double distance(double[] pointA, double[] pointB) {
        return Math.sqrt(Metric.distanceSquared(pointA, pointB));
    }

    public static double distanceWithDivisionSquared(double[] pointA, double dA) {
        double distance = 0.0;
        for (int i = 0; i < pointA.length; ++i) {
            double d = pointA[i] / dA;
            distance += d * d;
        }
        return distance;
    }

    public static double distanceWithDivision(double[] pointA, double dA) {
        return Math.sqrt(Metric.distanceWithDivisionSquared(pointA, dA));
    }

    public static double distanceWithDivisionSquared(double[] pointA, double dA, double[] pointB) {
        assert (pointA.length == pointB.length);
        double distance = 0.0;
        for (int i = 0; i < pointA.length; ++i) {
            double d = pointA[i] / dA - pointB[i];
            distance += d * d;
        }
        return distance;
    }

    public static double distanceWithDivision(double[] pointA, double dA, double[] pointB) {
        return Math.sqrt(Metric.distanceWithDivisionSquared(pointA, dA, pointB));
    }

    public static double distanceWithDivisionSquared(double[] pointA, double dA, double[] pointB, double dB) {
        assert (pointA.length == pointB.length);
        double distance = 0.0;
        for (int i = 0; i < pointA.length; ++i) {
            double d = pointA[i] / dA - pointB[i] / dB;
            distance += d * d;
        }
        return distance;
    }

    public static double distanceWithDivision(double[] pointA, double dA, double[] pointB, double dB) {
        return Math.sqrt(Metric.distanceWithDivisionSquared(pointA, dA, pointB, dB));
    }

    public static double dotProduct(double[] pointA) {
        double product = 0.0;
        for (int i = 0; i < pointA.length; ++i) {
            product += pointA[i] * pointA[i];
        }
        return product;
    }

    public static double dotProduct(double[] pointA, double[] pointB) {
        assert (pointA.length == pointB.length);
        double product = 0.0;
        for (int i = 0; i < pointA.length; ++i) {
            product += pointA[i] * pointB[i];
        }
        return product;
    }

    public static double dotProductWithAddition(double[] pointA1, double[] pointA2, double[] pointB) {
        assert (pointA1.length == pointA2.length && pointA1.length == pointB.length);
        double product = 0.0;
        for (int i = 0; i < pointA1.length; ++i) {
            product += (pointA1[i] + pointA2[i]) * pointB[i];
        }
        return product;
    }

    public static double dotProductWithAddition(double[] pointA1, double[] pointA2, double[] pointB1, double[] pointB2) {
        assert (pointA1.length == pointA2.length && pointB1.length == pointB2.length && pointA1.length == pointB1.length);
        double product = 0.0;
        for (int i = 0; i < pointA1.length; ++i) {
            product += (pointA1[i] + pointA2[i]) * (pointB1[i] + pointB2[i]);
        }
        return product;
    }
}

