% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/streambugs_examples.r
\name{streambugs.example.model.toy}
\alias{streambugs.example.model.toy}
\title{Set-up the streambugs toy model}
\usage{
streambugs.example.model.toy(n.Reaches = 3, n.Habitats = 2)
}
\arguments{
\item{n.Reaches}{Number of reaches in the toy example}

\item{n.Habitats}{Number of habitats in the toy example}
}
\value{
List with:\describe{
   \item{\code{$name}}{name of the example}
   \item{\code{$y.names}}{list with names of state variables as returned by
     the \link{decode.statevarnames} function}
   \item{\code{$times}, \code{$par}, \code{$inp}:}{corresponding input
         parameters of the \code{\link{run.streambugs}} function}
   }
}
\description{
Set-up state variables, parameters, input, and output times of the
streambugs toy model. The model is ready to run with
\code{\link{run.streambugs}}.
}
\section{Model syntax}{

See "docs/Streambugs_syntax.pdf" file in the package installation folder:
\code{system.file("docs", "Streambugs_syntax.pdf", package="streambugs")}.
}

\examples{
model <- streambugs.example.model.toy()
# display values of the exponent "q" in the food limitation term; Note:
model$par[grepl("(.*_)?q$", names(model$par))]

}
