% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/string_tools.R
\name{paste_conditional}
\alias{paste_conditional}
\title{Paste a string vector conditionally}
\usage{
paste_conditional(x, id, sep = " ", names = TRUE, sort = TRUE)
}
\arguments{
\item{x}{A character vector or a formula. If a vector: it represents the
values to be pasted together.
If a formula, it must be of the form
\code{my_string ~ id1 + id2} with on the left the character vector and on the right
the (possibly many) identifiers. If a formula, the argument \code{id} must be a
data frame.}

\item{id}{A vector of identifiers, a list of identifiers (can be a data frame),
or a \code{data.frame}. The identifiers can be a vector or a list of vectors. They represent
which elements of \code{x} are to be pasted together.

When \code{x} is a formula, then \code{id} must be a data.frame containing the variables in
the formula.}

\item{sep}{A character scalar, default is \code{" "}. The value used to paste together
the elements of \code{x}.}

\item{names}{Logical scalar, default is \code{TRUE}. Whether to add, as names, the values of
the identifiers.}

\item{sort}{Logical scalar, default is \code{TRUE}. Whether to sort the results according to
the identifiers.}
}
\value{
Returns a character vector. If the argument \code{names} is \code{TRUE} (default), the vector will have
names equal to the values of the identifiers.
}
\description{
Easily reconstruct a string vector that has been split with \code{\link[=string_split2df]{string_split2df()}}.
}
\examples{

#
# let's paste together the letters of the alphabet

# first we create the identifier
id = rep(1:2, each = 13)
setNames(id, letters)

# now we conditionally paste together the letters
paste_conditional(letters, id, "")

#
# using a formula

# we create a small data set based on mtcars
base_cars = within(mtcars, carname <- row.names(mtcars))
base_cars = head(base_cars, 10)

# we use two identifiers
paste_conditional(carname ~ gear + carb, base_cars, sep = ", ")



}
