% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-cache.R
\name{cache_make_key}
\alias{cache_make_key}
\title{Make a key for \code{R.cache}}
\usage{
cache_make_key(text, transformers, more_specs)
}
\arguments{
\item{text}{Code to create a cache for. This should be styled text, as the
approach used by styler does not cache input, but styled code.}

\item{transformers}{A list of transformer functions, because we can only
know if text is already correct if we know which transformer function it
should be styled with.}

\item{more_specs}{A named vector coercible to character that determines the
styling but are style guide independent, such as \code{include_roxygen_examples}
or \code{base_indention}.}
}
\description{
This is used to determine if caching already corresponds to a style guide.
}
\details{
We need to compare:
\itemize{
\item text to style. Will be passed to hash function as is.
\item styler version. Not an issue because for every version of styler, we build
a new cache.
\item transformers. Cannot easily hash them because two environments won't be
identical even if they contain the same objects (see 'Experiments'). Simple
\code{as.character(transformers)} will not consider infinitely recursive
code dependencies.
To fix this, transformers must have names and version number as described
in \code{\link[=create_style_guide]{create_style_guide()}}. Now, the only way to fool the cache invalidation
is to replace a transformer with the same function body (but changing
the function definition of the functions called in that body) interactively
without changing version number of name at the same time.
Remaining problem: \code{purrr::partial()} calls will render generic code, e.g.
see \code{as.character(list(purrr::partial(sum, x = 4)))}. For that reason,
all arguments passed to a \code{purrr::partial()} call must be put in the
style guide under \code{more_specs_style_guide}.
}
}
\section{Experiments}{


There is unexplainable behavior in conjunction with hashing and
environments:
\itemize{
\item Functions created with \code{purrr::partial()} are not identical when compared
with \code{identical()}
(\href{https://stackoverflow.com/questions/58656033/when-are-purrrpartial-ized-functions-identical}{StackOverflow})
\item except when they have the exact same parent environment, which must be an
object created and then passed to \code{purrr::partial(.env = ...)}, not
created in-place.
\item \code{purrr::partial()} seems to ignore \code{.env} after version 0.2.5, so until
this is fixed, we'd have to work with version 0.2.5.
\item Our caching backend package, \code{R.cache}, uses
\code{R.cache:::getChecksum.default} (which uses \code{digest::digest()}) to hash the
input. The latter does not seem to care if the environments are exactly
equal (see 'Examples').
\item However, under some circumstances, it does: Commit 9c94c022 (if not
overwritten / rebased by now) contains a reprex. Otherwise, search for
43219ixmypi in commit messages and restore this commit to reproduce the
behavior.
}
}

\examples{
add <- function(x, y) {
  x + y
}
add1 <- purrr::partial(add, x = 1)
add2 <- purrr::partial(add, x = 1)
identical(add1, add2)
identical(digest::digest(add1), digest::digest(add2))
identical(digest::digest(styler::tidyverse_style()), digest::digest(styler::tidyverse_style()))
}
\keyword{internal}
