% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SF.SIR.R
\name{SF.SIR}
\alias{SF.SIR}
\title{Sliced inverse regression for sufficient forecasting}
\usage{
SF.SIR(
  y,
  X,
  newX = NULL,
  type = "LM",
  K = "default",
  L = 1,
  discretization = TRUE,
  nslices = 10
)
}
\arguments{
\item{y}{Response, T by 1 matrix}

\item{X}{Predictors, p by T matrix}

\item{newX}{New predictors, a vector contains p entries (or \code{NULL})}

\item{type}{\code{LM} or \code{LLM} (default = \code{LM}), \code{type = LM} fits
a linear regression of the response on the estimated predictive indices;
\code{type = LLM} fits a local linear regression}

\item{K}{The number of common factors (default = obtained
by \code{\link{getK}})}

\item{L}{The number of predictive indices, L is required to be no greater than
K (default = 1)}

\item{discretization}{Hyperparameter in SIR (default = \code{TRUE})}

\item{nslices}{Hyperparameter in SIR (default = 10)}
}
\value{
Out-of-sample forecast for \code{newX}; or in-sample forecast for the last
observed data point if \code{newX} is \code{NULL}
}
\description{
Sliced inverse regression for sufficient forecasting
}
\examples{
utils::data(dataExample,package = "sufficientForecasting")
SF.SIR(dataExample$y,dataExample$X,type = "LLM")

}
\references{
Fan, J., Xue, L. and Yao, J. (2017), Sufficient forecasting using factor models,
\emph{Journal of econometrics} 201(2), 292–306.

Yu, X., Yao, J. and Xue, L. (2022), Nonparametric estimation and conformal inference
of the sufficient forecasting with a diverging number of factors,
\emph{Journal of Business & Economic Statistics} 40(1), 342–354.
}
