% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist_date.R
\name{dist_date}
\alias{dist_date}
\title{Summarize and visualize a date variable}
\usage{
dist_date(data, var, by = NULL)
}
\arguments{
\item{data}{A data frame or tibble.}

\item{var}{The date variable to summarise.}

\item{by}{Optional grouping variable.}
}
\value{
A tibble with summary statistics for the date variable.
}
\description{
Summarises the minimum, maximum, median, and interquartile range of a date variable,
optionally stratified by a grouping variable. Produces a histogram and (optionally) a density plot.
}
\examples{
# Example ungrouped
df <- tibble::tibble(
  dt = as.Date("2020-01-01") + sample(0:1000, 100, TRUE)
)
dist_date(df, dt)

# Example grouped
df2 <- tibble::tibble(
  dt = as.Date("2020-01-01") + sample(0:1000, 100, TRUE),
  grp = sample(1:2, 100, TRUE)
)
dist_date(df2, dt, grp)
# Note this function accepts a pipe from dplyr eg. df \%>\% dist_date(date_var, group_var)
}
\seealso{
\code{\link{dist_sum}} for continuous variables.
}
