% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim.R
\name{trim}
\alias{trim}
\title{Trim a character vector}
\usage{
trim(x)
}
\arguments{
\item{x}{\verb{[character]}.}
}
\value{
A character vector.
}
\description{
Almost identical to \code{\link[glue:trim]{glue::trim()}} save a slight difference in error
handling for non-character input. This function trims a character
vector according to the trimming rules used by glue. These follow similar
rules to \href{https://www.python.org/dev/peps/pep-0257/}{Python Docstrings},
with the following features:
\itemize{
\item Leading and trailing whitespace from the first and last lines is removed.
\item A uniform amount of indentation is stripped from the second line on, equal
to the minimum indentation of all non-blank lines after the first.
\item Lines can be continued across newlines by using \verb{\\\\}.
}
}
\examples{
cat(trim("
    A formatted string
    Can have multiple lines
      with additional indentation preserved
    "))

cat(trim("
  \ntrailing or leading newlines can be added explicitly\n
  "))

cat(trim("
    A formatted string \\\\
    can also be on a \\\\
    single line
    "))

}
\seealso{
\code{\link[glue:trim]{glue::trim()}}.
}
